/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.ASTVisitor;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.core.dom.DefaultASTVisitor;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.WorkingCopyManager;
import org.asnlab.asndt.internal.ui.text.asn.IAsnReconcilingListener;
import org.asnlab.asndt.internal.ui.text.asn.IProblemRequestorExtension;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AsnReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private WorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private boolean fNotify = true;
    private IAsnReconcilingListener fAsnReconcilingListener;
    private boolean fIsAsnReconcilingListener;

    public AsnReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = AsnPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = AsnPlugin.getDefault().getCompilationUnitDocumentProvider();
        this.fIsAsnReconcilingListener = this.fEditor instanceof IAsnReconcilingListener;
        if (this.fIsAsnReconcilingListener) {
            this.fAsnReconcilingListener = (IAsnReconcilingListener)this.fEditor;
        }
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    private void reconcile(final boolean initialReconcile) {
        final CompilationUnitDeclaration[] ast = new CompilationUnitDeclaration[1];
        try {
            final ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput(), false);
            if (unit != null) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        block12: {
                            try {
                                IProblemRequestorExtension extension = AsnReconcilingStrategy.this.getProblemRequestorExtension();
                                if (extension != null) {
                                    extension.setProgressMonitor(AsnReconcilingStrategy.this.fProgressMonitor);
                                    extension.setIsActive(true);
                                }
                                try {
                                    try {
                                        boolean isASTNeeded;
                                        boolean bl = isASTNeeded = initialReconcile || AsnPlugin.getDefault().getASTProvider().isActive(unit);
                                        if (AsnReconcilingStrategy.this.fIsAsnReconcilingListener && isASTNeeded) {
                                            ast[0] = unit.reconcile(true, true, null, AsnReconcilingStrategy.this.fProgressMonitor);
                                            if (ast[0] != null) {
                                                AsnReconcilingStrategy.setFlagsToAST((ASTNode)ast[0], 4);
                                            }
                                            break block12;
                                        }
                                        unit.reconcile(true, null, AsnReconcilingStrategy.this.fProgressMonitor);
                                    }
                                    catch (OperationCanceledException operationCanceledException) {
                                        Assert.isTrue((AsnReconcilingStrategy.this.fProgressMonitor == null || AsnReconcilingStrategy.this.fProgressMonitor.isCanceled() ? 1 : 0) != 0);
                                        ast[0] = null;
                                        if (extension != null) {
                                            extension.setProgressMonitor(null);
                                            extension.setIsActive(false);
                                        }
                                    }
                                }
                                finally {
                                    if (extension != null) {
                                        extension.setProgressMonitor(null);
                                        extension.setIsActive(false);
                                    }
                                }
                            }
                            catch (AsnModelException ex) {
                                this.handleException(ex);
                            }
                        }
                    }

                    public void handleException(Throwable ex) {
                        Status status = new Status(4, "org.asnlab.asndt.ui", 0, "Error in ASNDT Core during reconcile", ex);
                        AsnPlugin.getDefault().getLog().log((IStatus)status);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.fIsAsnReconcilingListener) {
                    IProgressMonitor pm = this.fProgressMonitor;
                    if (pm == null) {
                        pm = new NullProgressMonitor();
                    }
                    this.fAsnReconcilingListener.reconciled(ast[0], !this.fNotify, pm);
                }
            }
            finally {
                this.fNotify = true;
            }
            throw throwable;
        }
        try {
            if (this.fIsAsnReconcilingListener) {
                IProgressMonitor pm = this.fProgressMonitor;
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                this.fAsnReconcilingListener.reconciled(ast[0], !this.fNotify, pm);
            }
        }
        finally {
            this.fNotify = true;
        }
    }

    public static void setFlagsToAST(ASTNode root, final int flags) {
        root.accept((ASTVisitor)new DefaultASTVisitor(){

            protected boolean visitNode(ASTNode node) {
                node.setFlags(node.getFlags() | flags);
                return true;
            }
        });
    }

    public void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }

    public void aboutToBeReconciled() {
        if (this.fIsAsnReconcilingListener) {
            this.fAsnReconcilingListener.aboutToBeReconciled();
        }
    }
}

