/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.asncc;

import java.math.BigInteger;
import org.asnlab.asndt.asncc.FieldInfo;
import org.asnlab.asndt.asncc.ObjectInfo;
import org.asnlab.asndt.runtime.error.AsnLicenseException;

abstract class IntegerUtils {
    static final BigInteger f;
    static final BigInteger i;
    static final BigInteger F;

    protected static int orderOfDist(BigInteger a) {
        if (a.compareTo(i) <= 0) {
            return 0;
        }
        if (a.compareTo(f) == 0) {
            return 1;
        }
        if (a.compareTo(F) <= 0) {
            return 2;
        }
        return 3;
    }

    protected static int numOfBits(BigInteger a) {
        return a.bitLength();
    }

    public static String toHexString(byte[] a) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n = 0;
        while (n2 < a.length) {
            String string = Integer.toHexString(a[n] & 0xFF).toUpperCase();
            if (string.length() == 1) {
                stringBuffer.append(FieldInfo.l("H"));
            }
            stringBuffer.append(string);
            if (n != a.length - 1) {
                stringBuffer.append(ObjectInfo.l("\u0016"));
            }
            n2 = ++n;
        }
        return stringBuffer.toString();
    }

    IntegerUtils() {
        IntegerUtils a;
    }

    static byte[] parseHexString(String a) {
        int n;
        if (a.length() % 2 != 0) {
            throw new AsnLicenseException();
        }
        byte[] byArray = new byte[a.length() / 2];
        int n2 = n = 0;
        while (n2 < byArray.length) {
            int n3 = n;
            byte by = (byte)Integer.parseInt(a.substring(n * 2, n3 * 2 + 2), 16);
            byArray[n3] = by;
            n2 = ++n;
        }
        return byArray;
    }

    protected static int numOfOcts(long a) {
        int n = 0;
        --a;
        do {
            ++n;
        } while ((a >>>= 8) != 0L);
        return n;
    }

    protected static int numOfBytes(BigInteger a) {
        return a.bitLength() / 8 + 1;
    }

    protected static int numOfBits(long a) {
        int n = 0;
        long l = a = a - 1L;
        while (l != 0L) {
            ++n;
            l = a >>>= 1;
        }
        return n;
    }

    static {
        i = BigInteger.valueOf(254L);
        f = BigInteger.valueOf(255L);
        F = BigInteger.valueOf(65535L);
    }

    protected static int numBits2numOcts(int a) {
        return (a - 1 >> 3) + 1;
    }

    protected static int numOfOcts(int a) {
        --a;
        int n = 0;
        do {
            ++n;
        } while ((a >>>= 8) != 0);
        return n;
    }

    protected static int numOfBits(int a) {
        int n = 0;
        int n2 = --a;
        while (n2 != 0) {
            ++n;
            n2 = a >>>= 1;
        }
        return n;
    }

    protected static int numOfOcts(BigInteger a) {
        return (a.bitLength() - 1 >> 3) + 1;
    }
}

