/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Date;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SizeFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.asnlab.asndt.core.compiler.AsnCompiler;
import org.asnlab.asndt.internal.compiler.problem.ShouldNotImplement;

public class FileFilterUtils {
    private static /* synthetic */ IOFileFilter svnFilter;
    private static /* synthetic */ IOFileFilter cvsFilter;

    public static IOFileFilter ageFileFilter(File a2, boolean a3) {
        return new AgeFileFilter(a2, a3);
    }

    public static IOFileFilter ageFileFilter(File a2) {
        return new AgeFileFilter(a2);
    }

    public static IOFileFilter makeSVNAware(IOFileFilter a2) {
        if (svnFilter == null) {
            svnFilter = FileFilterUtils.notFileFilter(FileFilterUtils.andFileFilter(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(ShouldNotImplement.K("cB;_"))));
        }
        if (a2 == null) {
            return svnFilter;
        }
        return FileFilterUtils.andFileFilter(a2, svnFilter);
    }

    public static IOFileFilter makeFileOnly(IOFileFilter a2) {
        if (a2 == null) {
            return FileFileFilter.FILE;
        }
        return new AndFileFilter(FileFileFilter.FILE, a2);
    }

    public static IOFileFilter sizeFileFilter(long a2, boolean a3) {
        return new SizeFileFilter(a2, a3);
    }

    public static IOFileFilter asFileFilter(FilenameFilter a2) {
        return new DelegateFileFilter(a2);
    }

    public static IOFileFilter makeDirectoryOnly(IOFileFilter a2) {
        if (a2 == null) {
            return DirectoryFileFilter.DIRECTORY;
        }
        return new AndFileFilter(DirectoryFileFilter.DIRECTORY, a2);
    }

    public static IOFileFilter suffixFileFilter(String a2) {
        return new SuffixFileFilter(a2);
    }

    public static IOFileFilter ageFileFilter(Date a2) {
        return new AgeFileFilter(a2);
    }

    public static IOFileFilter sizeFileFilter(long a2) {
        return new SizeFileFilter(a2);
    }

    public static IOFileFilter nameFileFilter(String a2) {
        return new NameFileFilter(a2);
    }

    public static IOFileFilter ageFileFilter(long a2) {
        return new AgeFileFilter(a2);
    }

    public static String K(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = 5 << 3 ^ 3;
        int cfr_ignored_0 = (2 ^ 5) << 4 ^ 5 << 1;
        int n5 = n3;
        int n6 = 3 << 3;
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(a2.charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    public static IOFileFilter ageFileFilter(long a2, boolean a3) {
        return new AgeFileFilter(a2, a3);
    }

    public FileFilterUtils() {
        FileFilterUtils a2;
    }

    public static IOFileFilter falseFileFilter() {
        return FalseFileFilter.FALSE;
    }

    public static IOFileFilter sizeRangeFileFilter(long a2, long a32) {
        SizeFileFilter sizeFileFilter = new SizeFileFilter(a2, true);
        SizeFileFilter a32 = new SizeFileFilter(a32 + 1L, false);
        return new AndFileFilter(sizeFileFilter, a32);
    }

    public static IOFileFilter fileFileFilter() {
        return FileFileFilter.FILE;
    }

    public static IOFileFilter prefixFileFilter(String a2) {
        return new PrefixFileFilter(a2);
    }

    public static IOFileFilter trueFileFilter() {
        return TrueFileFilter.TRUE;
    }

    public static IOFileFilter andFileFilter(IOFileFilter a2, IOFileFilter a3) {
        return new AndFileFilter(a2, a3);
    }

    public static IOFileFilter asFileFilter(FileFilter a2) {
        return new DelegateFileFilter(a2);
    }

    public static IOFileFilter makeCVSAware(IOFileFilter a2) {
        if (cvsFilter == null) {
            cvsFilter = FileFilterUtils.notFileFilter(FileFilterUtils.andFileFilter(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(AsnCompiler.K("L\u0006\\"))));
        }
        if (a2 == null) {
            return cvsFilter;
        }
        return FileFilterUtils.andFileFilter(a2, cvsFilter);
    }

    public static IOFileFilter orFileFilter(IOFileFilter a2, IOFileFilter a3) {
        return new OrFileFilter(a2, a3);
    }

    public static IOFileFilter notFileFilter(IOFileFilter a2) {
        return new NotFileFilter(a2);
    }

    public static IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.DIRECTORY;
    }

    public static IOFileFilter ageFileFilter(Date a2, boolean a3) {
        return new AgeFileFilter(a2, a3);
    }
}

