/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui;

import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnModel;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IContainmentAdapter;

public class AsnElementContainmentAdapter
implements IContainmentAdapter {
    private IAsnModel fAsnModel = AsnCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

    public boolean contains(Object workingSetElement, Object element, int flags) {
        if (!(workingSetElement instanceof IAsnElement) || element == null) {
            return false;
        }
        IAsnElement workingSetAsnElement = (IAsnElement)workingSetElement;
        IResource resource = null;
        IAsnElement aElement = null;
        if (element instanceof IAsnElement) {
            aElement = (IAsnElement)element;
            resource = aElement.getResource();
        } else if (element instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null && this.fAsnModel.contains(resource) && (aElement = AsnCore.create((IResource)resource)) != null && !aElement.exists()) {
            aElement = null;
        }
        if (aElement != null) {
            if (this.contains(workingSetAsnElement, aElement, flags)) {
                return true;
            }
            if (workingSetAsnElement.getElementType() == 4 && resource.getType() == 2 && this.checkIfDescendant(flags)) {
                return this.isChild(workingSetAsnElement, resource);
            }
        } else if (resource != null) {
            return this.contains(workingSetAsnElement, resource, flags);
        }
        return false;
    }

    private boolean contains(IAsnElement workingSetElement, IAsnElement element, int flags) {
        if (this.checkContext(flags) && workingSetElement.equals(element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetElement.equals(element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetElement, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetElement);
    }

    private boolean check(IAsnElement ancestor, IAsnElement descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals(descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean isChild(IAsnElement workingSetElement, IResource element) {
        IResource resource = workingSetElement.getResource();
        if (resource == null) {
            return false;
        }
        return this.check(element, resource);
    }

    private boolean contains(IAsnElement workingSetElement, IResource element, int flags) {
        IResource workingSetResource = workingSetElement.getResource();
        if (workingSetResource == null) {
            return false;
        }
        if (this.checkContext(flags) && workingSetResource.equals((Object)element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetResource.equals((Object)element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetResource, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetResource);
    }

    private boolean check(IResource ancestor, IResource descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean checkIfDescendant(int flags) {
        return (flags & 8) != 0;
    }

    private boolean checkIfAncestor(int flags) {
        return (flags & 4) != 0;
    }

    private boolean checkIfChild(int flags) {
        return (flags & 2) != 0;
    }

    private boolean checkContext(int flags) {
        return (flags & 1) != 0;
    }
}

