/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.IBuildPathEntry;
import org.asnlab.asndt.internal.core.AsnProject;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.util.CoreUtility;
import org.asnlab.asndt.internal.ui.util.ExceptionHandler;
import org.asnlab.asndt.internal.ui.wizards.AsnProjectWizardPage;
import org.asnlab.asndt.internal.ui.wizards.NewElementWizard;
import org.asnlab.asndt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AsnProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    public static final String FILENAME_BUILDPATH = ".buildpath";
    private IConfigurationElement fConfigElement;
    private AsnProjectWizardPage fPage;
    private IProject fCurrProject;
    private IAsnProject fAsnProject;

    public AsnProjectWizard() {
        this.setDefaultPageImageDescriptor(AsnPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(AsnPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.AsnProjectWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fPage = new AsnProjectWizardPage();
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            boolean hasNature;
            Object element = selection.getFirstElement();
            IProject project = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof IAdaptable) {
                project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
            }
            if (project != null && !(hasNature = AsnProject.hasAsnNature((IProject)project))) {
                this.fPage.setProjectName(project.getName());
                this.fPage.setCreateNewAsnProjct(false);
            }
        }
        this.addPage((IWizardPage)this.fPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        try {
            monitor.beginTask(NewWizardMessages.AsnProjectWizardSecondPage_operation_create, 5);
            this.createProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            AsnProject.addAsnNature((IProject)this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.configureBuildPath((IProgressMonitor)new SubProgressMonitor(monitor, 3));
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
        }
    }

    final void createProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.AsnProjectWizardSecondPage_operation_initialize, 2);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fCurrProject = this.fPage.getProjectHandle();
            if (!this.fCurrProject.exists()) {
                IProjectDescription desc = this.fCurrProject.getWorkspace().newProjectDescription(this.fCurrProject.getName());
                this.fCurrProject.create(desc, monitor);
            }
            monitor.worked(1);
            if (!this.fCurrProject.isOpen()) {
                this.fCurrProject.open(monitor);
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    public void configureBuildPath(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.AsnCapabilityConfigurationPage_op_desc_asn, 3);
            this.fAsnProject = AsnCore.create((IProject)this.fCurrProject);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IBuildPathEntry[] entries = null;
            if (this.fCurrProject.getFile(FILENAME_BUILDPATH).exists()) {
                entries = this.fAsnProject.readBuildPathFile();
            }
            if (entries == null) {
                Path srcPath = new Path(this.fPage.getSourceFolder());
                if (srcPath.segmentCount() > 0) {
                    IFolder folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                Path binPath = new Path(this.fPage.getOutputFolder());
                if (binPath.segmentCount() > 0) {
                    IFolder folder = this.fCurrProject.getFolder((IPath)binPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IBuildPathEntry> bpEntries = new ArrayList<IBuildPathEntry>();
                bpEntries.add(AsnCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                bpEntries.add(AsnCore.newOutputEntry((IPath)projectPath.append((IPath)binPath)));
                entries = bpEntries.toArray(new IBuildPathEntry[bpEntries.size()]);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.fAsnProject.setBuildPath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(2);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fAsnProject.getProject());
            try {
                this.fAsnProject.open(null);
            }
            catch (AsnModelException e) {
                AsnPlugin.log(e);
            }
        }
        return res;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.AsnProjectWizard_op_error_title;
        String message = NewWizardMessages.AsnProjectWizard_op_error_create_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.removeProject();
        return super.performCancel();
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AsnProjectWizard.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.AsnProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.AsnProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.AsnProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                boolean removeContent = this.fCurrProject.isSynchronized(2);
                this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
        }
    }

    public IAsnElement getCreatedElement() {
        return AsnCore.create((IProject)this.fPage.getProjectHandle());
    }
}

