/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.core;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IBuffer;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IOpenable;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.internal.core.AsnElement;
import org.asnlab.asndt.internal.core.Openable;
import org.asnlab.asndt.internal.core.SourceRange;
import org.asnlab.asndt.internal.core.util.DOMFinder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class SourceRefElement
extends AsnElement
implements ISourceReference {
    public int sourceEnd;
    public int occurrenceCount = 1;
    public int sourceStart;

    @Override
    public IResource getUnderlyingResource() throws AsnModelException {
        SourceRefElement a;
        if (!a.exists()) {
            throw a.newNotPresentException();
        }
        return a.getParent().getUnderlyingResource();
    }

    @Override
    public IResource getResource() {
        SourceRefElement a;
        return a.getParent().getResource();
    }

    @Override
    public IOpenable getOpenableParent() {
        SourceRefElement a;
        IAsnElement iAsnElement;
        IAsnElement iAsnElement2 = iAsnElement = a.getParent();
        while (iAsnElement2 != null) {
            if (iAsnElement instanceof IOpenable) {
                return (IOpenable)((Object)iAsnElement);
            }
            iAsnElement2 = iAsnElement.getParent();
        }
        return null;
    }

    public void updateSourceRange(int a, int a2) {
        SourceRefElement a3;
        SourceRefElement sourceRefElement = a3;
        sourceRefElement.sourceStart = a;
        sourceRefElement.sourceEnd = a2;
    }

    @Override
    public String getSource() throws AsnModelException {
        SourceRefElement a;
        IBuffer iBuffer = a.getOpenableParent().getBuffer();
        if (iBuffer == null) {
            return null;
        }
        ISourceRange iSourceRange = a.getSourceRange();
        int n = iSourceRange.getOffset();
        int n2 = iSourceRange.getLength();
        if (n == -1 || n2 == 0) {
            return null;
        }
        try {
            return iBuffer.getText(n, n2);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ASTNode findNode(CompilationUnitDeclaration a3) {
        SourceRefElement a2;
        a3 = new DOMFinder((CompilationUnitDeclaration)a3, a2, false);
        try {
            return ((DOMFinder)a3).search();
        }
        catch (AsnModelException a3) {
            return null;
        }
    }

    @Override
    public IResource getCorrespondingResource() throws AsnModelException {
        SourceRefElement a;
        if (!a.exists()) {
            throw a.newNotPresentException();
        }
        return null;
    }

    @Override
    public IPath getPath() {
        SourceRefElement a;
        return a.getParent().getPath();
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        SourceRefElement a;
        return ((AsnElement)a.getParent()).getCompilationUnit();
    }

    @Override
    public boolean hasChildren() throws AsnModelException {
        SourceRefElement a;
        return a.getChildren().length > 0;
    }

    @Override
    public ISourceRange getSourceRange() {
        SourceRefElement a;
        SourceRefElement sourceRefElement = a;
        return new SourceRange(sourceRefElement.sourceStart, sourceRefElement.sourceEnd - a.sourceStart + 1);
    }

    @Override
    protected void closing() throws AsnModelException {
    }

    protected SourceRefElement(IAsnElement a) {
        super(a);
        SourceRefElement a2;
    }

    @Override
    protected void buildStructure(IProgressMonitor a) throws AsnModelException {
        SourceRefElement a2;
        Openable openable = (Openable)a2.getOpenableParent();
        if (openable != null && !openable.isOpen()) {
            openable.openWhenClosed(a);
        }
    }

    @Override
    public boolean equals(Object a) {
        SourceRefElement a2;
        if (!(a instanceof SourceRefElement)) {
            return false;
        }
        return a2.occurrenceCount == ((SourceRefElement)a).occurrenceCount && super.equals(a);
    }

    @Override
    public boolean isStructureKnown() {
        return true;
    }

    public int getOccurrenceCount() {
        SourceRefElement a;
        return a.occurrenceCount;
    }
}

