/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences;

import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.internal.corext.util.Resources;
import org.asnlab.asndt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class AsnElementInfoPage
extends PropertyPage {
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.asnlab.asndt.ui.asn_element_info_page_context");
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IAsnElement element = (IAsnElement)this.getElement();
        IResource resource = element.getResource();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(PreferencesMessages.AsnElementInfoPage_nameLabel);
        Label nameValueLabel = new Label(composite, 0);
        nameValueLabel.setText(element.getElementName());
        if (resource != null) {
            Label pathLabel = new Label(composite, 0);
            pathLabel.setText(PreferencesMessages.AsnElementInfoPage_resource_path);
            Label pathValueLabel = new Label(composite, 0);
            pathValueLabel.setText(resource.getFullPath().toString());
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)element;
            Label packageLabel = new Label(composite, 0);
            packageLabel.setText(PreferencesMessages.AsnElementInfoPage_package);
            Label packageName = new Label(composite, 0);
            packageName.setText(unit.getParent().getElementName());
        } else if (element instanceof ISourceFolder) {
            ISourceFolder cfr_ignored_0 = (ISourceFolder)element;
            Label packageContents = new Label(composite, 0);
            packageContents.setText(PreferencesMessages.AsnElementInfoPage_package_contents);
            Label packageContentsType = new Label(composite, 0);
            packageContentsType.setText(PreferencesMessages.AsnElementInfoPage_source);
        } else if (element instanceof ISourceFolder) {
            Label rootContents = new Label(composite, 0);
            rootContents.setText(PreferencesMessages.AsnElementInfoPage_classpath_entry_kind);
            Label rootContentsType = new Label(composite, 0);
            rootContentsType.setText(PreferencesMessages.AsnElementInfoPage_source);
        } else if (element instanceof IAsnProject) {
            Label packageLabel = new Label(composite, 0);
            packageLabel.setText(PreferencesMessages.AsnElementInfoPage_location);
            String location = Resources.getLocationString((IResource)((IAsnProject)element).getProject());
            if (location != null) {
                Label packageName = new Label(composite, 0);
                packageName.setText(location);
            }
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }
}

